---
Difficulty: Medium
Source: Daily-Question(POTD 24-Nov)
Tags:
    - Array
    - Greedy
    - Matrix
---

# 🚀 *1975 - Maximum Matrix Sum* 🧠

### Problem Link:
[**LeetCode - Maximum Matrix Sum**](https://leetcode.com/problems/maximum-matrix-sum/description/?envType=daily-question&envId=2024-11-24)


## 💡 **Problem Breakdown:**

You are given an `n x n` integer matrix.  
You can perform the following operation any number of times:
- Select **two adjacent elements** in the matrix and multiply **both by -1**.  

Two elements are adjacent if they share a border (vertically or horizontally).

Your task is to maximize the sum of the matrix’s elements after performing any number of such operations.


## 🔍 **Example Walkthrough:**

### Example 1:
<img src="https://github.com/user-attachments/assets/3942864e-3a44-463f-8440-7b44829773a6" width="45%">

**Input:**  
`matrix = [[1, -1], [-1, 1]]`  
**Output:**  
`4`  

**Explanation:**
- Step 1: Multiply both elements in the first row by `-1`: `[[1, 1], [-1, 1]]`.
- Step 2: Multiply both elements in the first column by `-1`: `[[1, 1], [1, 1]]`.
- Sum of the matrix = `4`.



### Example 2:
<img src="https://github.com/user-attachments/assets/3943db8e-78f4-431b-aa86-32a4e2cf1643" width="45%">

**Input:**  
`matrix = [[1, 2, 3], [-1, -2, -3], [1, 2, 3]]`  
**Output:**  
`16`  

**Explanation:**  
- Step 1: Multiply the last two elements in the second row by `-1`: `[[1, 2, 3], [-1, 2, 3], [1, 2, 3]]`.  
- Sum of the matrix = `16`.


### Constraints:

- `n == matrix.length == matrix[i].length`
- `2 <= n <= 250`
- `-10⁵ <= matrix[i][j] <= 10⁵`



## 🎯 **My Approach:**

1. **Understand the Impact of Flipping:**
   - Flipping adjacent elements allows you to cancel negatives. This means the sign of the entire matrix is dictated by whether there is an **odd or even count of negatives**.
   - If the negatives are even, all elements can be made positive.  
   - If the negatives are odd, the smallest absolute value will remain negative.

2. **Steps:**
   - Compute the **absolute sum** of all elements in the matrix.
   - Find the **minimum absolute value** in the matrix.
   - Count the total **number of negative values**.
   - If the negatives are odd, subtract `2 × min_abs_value` from the total sum.



## 🕒 **Time Complexity:**

- **O(n²):** Traverse the entire `n x n` matrix once.
  
## 📝 **Space Complexity:**

- **O(1):** No extra space is used apart from variables for tracking sums and counts.



## 📝 **Solution Code**

## Code (C):
```c
long long maxMatrixSum(int** matrix, int matrixSize, int* matrixColSize) {
    long long totalSum = 0;
    int minAbsValue = INT_MAX;
    int negativeCount = 0;

    for (int i = 0; i < matrixSize; i++) {
        for (int j = 0; j < matrixColSize[i]; j++) {
            int value = matrix[i][j];

            if (value < 0) {
                negativeCount++;
                value = -value;
            }

            totalSum += value;

            if (value < minAbsValue) {
                minAbsValue = value;
            }
        }
    }

    if (negativeCount & 1) { 
        totalSum -= 2LL * minAbsValue;
    }

    return totalSum;
}
```



## **C++ Code:**
```cpp
class Solution {
public:
    long long maxMatrixSum(vector<vector<int>>& matrix) {
        long long totalSum = 0;
        int minAbsValue = INT_MAX;
        int negativeCount = 0;

        for (const auto& row : matrix) {
            for (int value : row) {
                int absValue = abs(value);
                totalSum += absValue;
                minAbsValue = min(minAbsValue, absValue);
                if (value < 0) negativeCount++;
            }
        }

        if (negativeCount % 2 != 0) {
            totalSum -= 2LL * minAbsValue;
        }

        return totalSum;
    }
};
```



## Code (Java):
```java
class Solution {
    public long maxMatrixSum(int[][] matrix) {
        long totalSum = 0;
        int minAbsValue = Integer.MAX_VALUE;
        int negativeCount = 0;

        for (int[] row : matrix) {
            for (int value : row) {
                int absValue = Math.abs(value);
                totalSum += absValue;
                minAbsValue = Math.min(minAbsValue, absValue);
                if (value < 0) negativeCount++;
            }
        }

        if (negativeCount % 2 != 0) {
            totalSum -= 2L * minAbsValue;
        }

        return totalSum;
    }
}
```



## Code (Python3):

```python3
class Solution:
    def maxMatrixSum(self, matrix: List[List[int]]) -> int:
        total_sum = sum(abs(value) for row in matrix for value in row)
        min_abs_value = min(abs(value) for row in matrix for value in row)
        negative_count = sum(1 for row in matrix for value in row if value < 0)
        
        return total_sum - (2 * min_abs_value if negative_count % 2 != 0 else 0)
```



## Code (Rust):
```rust
impl Solution {
    pub fn max_matrix_sum(matrix: Vec<Vec<i32>>) -> i64 {
        let mut total_sum: i64 = 0;
        let mut min_abs_value = i32::MAX;
        let mut negative_count = 0;

        for row in matrix.iter() {
            for &value in row.iter() {
                let abs_value = value.abs();
                total_sum += abs_value as i64;
                if abs_value < min_abs_value {
                    min_abs_value = abs_value;
                }
                if value < 0 {
                    negative_count += 1;
                }
            }
        }

        if negative_count % 2 != 0 {
            total_sum -= 2 * min_abs_value as i64;
        }

        total_sum
    }
}
```



# 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).


## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:25px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
